function simRank(obj,varargin)
%SIMRANK Create similarity matrix using the algorithm of Jeh, Widom from
%   SimRank: A Measure of Structural-Context Similarity
%       from Proceedings of the eighth ACM SIGKDD international conference
%       on Knowledge discovery and data mining (Association of Computing
%       Machinery, New York, 2002), pp. 538-543
quiet = false;
for i = 1:2:numel(varargin)
    switch varargin{i}
        case 'quiet'
            quiet = varargin{i+1};
    end
end

[A obj.Slabels] = getSquareMatrix(obj.adjMat);

S = sparse(eye(size(A,1)));
S2 = S;

outMat = sum(A,2) * sum(A,2)';
inMat = sum(A)' * sum(A);

if ~quiet, fprintf('Epsilon for convergence of similarity matrix:\n'); end
for i = 1:500
    %         S
    %     input('press enter for next iteration','s')
    S2 = updateSimRank(A,S,obj.outWeight,obj.inWeight,outMat,inMat);
    if ~quiet
        diff = norm(S2-S,'fro');
        fprintf('%.10f\n',diff);
    end
    S = S2;
    
end

m = full(min(S(:)));
[I J] = find(S == m);

if ~quiet
    fprintf('Minimum similarity: %.10f, between %s and %s\n',m,obj.Slabels{I(1)},obj.Slabels{J(1)});
    tmp = triu(S);
    hist(tmp(tmp>0),max(10,size(S,1)/10)); title('Histogram of similarity values');
end
obj.S = S;


end
